{ A modal dialog box to modify the axis scales on the chart in the display.pas
  file. The dialog box contains edit boxes for the axis minimum, maximum, and
  increment; a radio group box to choose linear or logarithmic axis; and a
  checkbox to enable/disable autoscaling. Any changes made to the edit boxes
  automatically disable autoscaling. }
unit ScaleDlg;
      
interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, stypes;

type
  TDlgScale = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    Bevel1: TBevel;
    LblMin: TLabel;
    LblMax: TLabel;
    EdMinValue: TEdit;
    EdMaxValue: TEdit;
    LblScale: TLabel;
    RGAxisType: TRadioGroup;
    LblIncrem: TLabel;
    EdIncrem: TEdit;
    CBAuto: TCheckBox;
    procedure OKBtnClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure EditExit(Sender:TObject);
    procedure RGAxisTypeExit(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  DlgScale: TDlgScale;

implementation

uses display;

{$R *.DFM}

{ Before showing the form set the Dialog box title and default values for all
  objects. These values are dependent on which axis is the current axis in the
  chart. }
procedure TDlgScale.FormShow(Sender: TObject);
begin
  if FmDisplayData.CurrentAxis = axBottom then    // Independent Axis
    begin
      DlgScale.Caption := 'Independent Axis';
      // If axis is logarithmic
      if FmDisplayData.ChOutput.BottomAxis.Logarithmic = True then
       RGAxisType.ItemIndex := 1     // Check logarithmic radio button
      else
       RGAxisType.ItemIndex := 0;    // Check linear radio button
      FmDisplayData.ChOutput.BottomAxis.AdjustMaxMin;
      // Get current minimum axis value from the chart in the Display Form
      EdMinValue.text := floattostr(FmDisplayData.ChOutput.BottomAxis.Minimum);
      // Get current maximum axis value from the chart in the Display Form
      EdMaxValue.text := floattostr(FmDisplayData.ChOutput.BottomAxis.Maximum);
      // Get current increment value from the chart in the Display Form
      EdIncrem.text := floattostr(FmDisplayData.ChOutput.BottomAxis.Increment);
      // If the axis is set to autoscale, check the autoscale checkbox.
      if FmDisplayData.ChOutput.BottomAxis.Automatic = true then
        CBAuto.Checked := true
      else
        CBAuto.Checked := false;
    end
  else  // CurrentAxis = axLeft     Dependent Axis
    begin
      DlgScale.Caption := 'Dependent Axis' ;
      // If axis is logarithmic
      if FmDisplayData.ChOutput.LeftAxis.Logarithmic = True then
       RGAxisType.ItemIndex := 1    // Check logarithmic radio button
      else
       RGAxisType.ItemIndex := 0;   // Check linear radio button
      // Get current minimum axis value from the chart in the Display Form
      EdMinValue.text := floattostr(FmDisplayData.ChOutput.LeftAxis.Minimum);
      // Get current maximum axis value from the chart in the Display Form
      EdMaxValue.text := floattostr(FmDisplayData.ChOutput.LeftAxis.Maximum);
      // Get current increment value from the chart in the Display Form
      EdIncrem.text := floattostr(FmDisplayData.ChOutput.LeftAxis.Increment);
      // If the axis is set to autoscale, check the autoscale checkbox.
      if FmDisplayData.ChOutput.LeftAxis.AutomaticMaximum = true then
        CBAuto.Checked := true
      else
        CBAuto.Checked := false;
    end;
end;

// Implement any changes made in this dialog
procedure TDlgScale.OKBtnClick(Sender: TObject);
var
 MinValue, MaxValue, Increm:double;
begin
if CbAuto.checked = false then  // If the autoscale check box is unchecked
 begin
   MinValue := strtofloat(EdMinValue.text);
   MaxValue := strtofloat(EdMaxValue.text);
   Increm := strtofloat(EdIncrem.text);
   FmDisplayData.SetAxisScale(FmDisplayData.CurrentAxis, MinValue, MaxValue,
                               Increm, False);
 end
else // Autoscale checkbox is checked, ignore max, min and increment values
 begin     // Set autoscale to true
   MinValue := 0;
   MaxValue := 0;
   Increm := 0;
   FmDisplayData.SetAxisScale(FmDisplayData.CurrentAxis, MinValue, MaxValue,
                               Increm, True);
 end;
end;

procedure TDlgScale.EditExit(Sender:TObject);
begin
  if (Sender as TEdit).modified = true then
    CBAuto.Checked := false;
end;

{ Set the axis type based on which item is checked in the radio group. }
procedure TDlgScale.RGAxisTypeExit(Sender: TObject);
begin
 if RGAxisType.ItemIndex = 1 then // Axis type is logarithmic
   FmDisplayData.SetAxisType(FmDisplayData.CurrentAxis,tyLog)
 else
   FmDisplayData.SetAxisType(FmDisplayData.CurrentAxis,tyLinear)
end;

end.
